/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_ram_dq ( q, data, inclock, outclock, we, address) ;

  parameter lpm_type = "lpm_ram_dq" ;
  parameter lpm_width  = 1 ;
  parameter lpm_widthad = 1 ;
  parameter lpm_numwords = 2 ;
  parameter lpm_file       = "UNUSED" ;
  parameter lpm_indata   = "REGISTERED" ;
  parameter lpm_outdata  = "REGISTERED" ;
  parameter lpm_addr_control  = "REGISTERED" ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_inclock  = "NORMAL" ;
  parameter polar_outclock = "NORMAL" ;
  parameter polar_we       = "NORMAL" ;
  parameter polar_address  = "NORMAL" ;
  parameter polar_q        = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  [lpm_widthad-1:0] address ;
  input  inclock, outclock, we ;
  output [lpm_width-1:0] q;


  // internal reg 
  reg   [lpm_width-1:0] memRAM [lpm_numwords-1:0];
  reg   [lpm_width-1:0] tmp_q ;
  reg   [lpm_width-1:0] pdata ;
  reg   [lpm_widthad-1:0] paddress ;
  reg   pinclock, poutclock, pwe;
  reg   [lpm_width-1:0] ONES, ZEROS, UNKNOWN ;
  reg [8*256:1] ram_initf ;
  integer i ;

  function ValidAddress ;
	input [lpm_widthad-1:0] paddress ;
	begin
		ValidAddress = 1'b0 ;
		if(^paddress ==='bx)
			$display("%d:Error! Invalid address.\n", $time) ;
		else if(paddress >= lpm_numwords)
			$display("%d:Error! Address out of bound on RAM.\n", $time) ;
		else
			ValidAddress = 1'b1 ;
	end
  endfunction
		
  initial
  begin

	// check for number of words out of bound
	if(lpm_numwords > (1 << lpm_widthad))
	begin
		$display("Error! Too many words defined.\n");
		$stop;
	end

	// check if lpm_indata or lpm_addr_control is set to registered
	// inclock must be used.
	if(((lpm_indata === "REGISTERED") || (lpm_addr_control === "REGISTERED")) && (inclock === 1'bz))
	begin
		$display("Error! inclock = 1'bz. Inclock pin must be used.\n");
	end

	// check if lpm_outdata, outclock must be used
	if((lpm_outdata === "REGISTERED") && (outclock === 1'bz))
	begin
		$display("Error! lpm_outdata = REGISTERED, outclock = 1'bz . Outclock pin must be used.\n");
	end

	for(i=0; i < lpm_width; i=i+1)
	begin
		ONES[i] = 1'b1 ;
		ZEROS[i] = 1'b0 ;
		UNKNOWN[i] = 1'bX ;
	end	
	
	for(i = 0; i < lpm_numwords; i=i+1)
		memRAM[i] = ZEROS ;

    // load data to the RAM
    if(lpm_file != "UNUSED")
    begin
`ifdef SYNTH
`else
     $convert_hex2ver(lpm_file, lpm_width, ram_initf);
`endif
        $readmemh(ram_initf, memRAM);
    end 

  end

  always @(inclock)
	  pinclock <= #1 (polar_inclock == "INVERT")?~inclock:inclock;
	 	
  always @(outclock)
	  poutclock <= #1 (polar_outclock == "INVERT")?~outclock:outclock;
  always @(data)
		pdata <= #1 (polar_data == "INVERT")?~data:data;
	
	 	
  always @(address)
  begin
	if(lpm_addr_control === "UNREGISTERED")
		paddress <= #1 (polar_address == "INVERT")?~address:address;
  end
	
  always @(we)
  begin
	if(lpm_addr_control === "UNREGISTERED")
		pwe <= #1 (polar_we == "INVERT")?~we:we;
  end
	
  always @( pdata or paddress or pwe )
    begin :unregistered_inclock
		if(ValidAddress(paddress))
		begin
      		if (pwe)
			begin
				if(lpm_indata === "UNREGISTERED")
		  		begin :unregistered_indata_block
					memRAM[paddress] = pdata ;
				end
		  	end

			if(lpm_outdata === "UNREGISTERED")
				tmp_q = memRAM[paddress] ;
		end
      	else
		begin
			if(lpm_outdata === "UNREGISTERED")
				tmp_q = UNKNOWN ;
		end
	end

  always @(posedge pinclock)
    begin
		disable unregistered_inclock;
		if(lpm_addr_control === "REGISTERED")
		begin
			pwe <= #1 (polar_we == "INVERT")?~we:we;
			paddress <= #1 (polar_address == "INVERT")?~address:address;
		end

		if(ValidAddress(paddress))
		begin
			if(pwe)
			begin
				if(lpm_indata === "REGISTERED")
				begin
					memRAM[paddress] = pdata ;
				end
			end

			if(lpm_outdata === "UNREGISTERED")
				tmp_q = memRAM[paddress] ;
		end
	end
 
  always @(posedge poutclock)
    begin
		if(lpm_outdata === "REGISTERED")
		begin
			if(ValidAddress(paddress))
				#0 tmp_q = memRAM[paddress] ;
			else
				tmp_q = UNKNOWN ;
		end
	end
 
  assign q = (polar_q == "INVERT")?~tmp_q:tmp_q ;

endmodule // lpm_ram_dq
`ifdef SYNTH
`else
`endcelldefine
`endif
 
